unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TRownanieKwadratowe = class
  strict private
    function Delta :Double;
  public
    a,b,c :Double;
    constructor Create(a,b,c :Double);
    function X1 :Double;
    function X2 :Double;
    function IloscPierwiastkow :Integer;
    class function Opis :String;
    class function Rozwiazanie(a,b,c :Double; var x1 :Double; var x2 :Double): Boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

constructor TRownanieKwadratowe.Create(a,b,c :Double);
begin
inherited Create;
Self.a:=a;
Self.b:=b;
Self.c:=c;
end;

function TRownanieKwadratowe.Delta :Double;
begin
Result:=b*b-4*a*c;
end;

function TRownanieKwadratowe.X1 :Double;
begin
if Delta<0 then raise Exception.Create('Rwnanie nie ma rozwiza');
Result:=(-b-Sqrt(Delta))/(2*a);
end;

function TRownanieKwadratowe.X2 :Double;
begin
if Delta<0 then raise Exception.Create('Rwnanie nie ma rozwiza');
Result:=(-b+Sqrt(Delta))/(2*a);
end;

function TRownanieKwadratowe.IloscPierwiastkow :Integer;
begin
Result:=0;
if Delta>0 then Result:=2;
if Delta=0 then Result:=1;
end;

class function TRownanieKwadratowe.Opis :String;
begin
Result:='Rozwizywanie rwnania kwadratowego';
end;

class function TRownanieKwadratowe.Rozwiazanie(a,b,c :Double; var x1 :Double; var x2 :Double): Boolean;
var rk :TRownanieKwadratowe;
begin
rk:=TRownanieKwadratowe.Create(a,b,c);
if rk.IloscPierwiastkow>0 then
  begin
  x1:=rk.X1;
  x2:=rk.X2;
  Result:=True;
  end
  else Result:=False;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  a,b,c :Double;
  rk :TRownanieKwadratowe;
begin
try
  a:=StrToFloat(Edit1.Text);
  b:=StrToFloat(Edit2.Text);
  c:=StrToFloat(Edit3.Text);
  rk:=TRownanieKwadratowe.Create(a,b,c);
  if rk.IloscPierwiastkow>0
    then ShowMessage('Rozwizania: x1='+FloatToStr(rk.X1)+', x2='+FloatToStr(rk.X2))
    else ShowMessage('Rwnanie nie ma rozwiza');
  rk.Free;
except
  on E: EConvertError do
    begin
    Edit4.Clear;
    ShowMessage('Bd konwersji wspczynnikw rwnania!'+#13+'Komunikat wyjtku: '+E.Message);
    Exit;
    end;
  on E: Exception do
    begin
    Edit4.Clear;
    ShowMessage('Bd: '+E.Message);
    Exit;
    end;
else
  begin
  Edit4.Clear;
  ShowMessage('Wystpi nierozpoznany typ bdu!');
  Exit;
  end;
end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  a,b,c :Double;
  x1,x2 :Double;
begin
a:=StrToFloat(Edit1.Text);
b:=StrToFloat(Edit2.Text);
c:=StrToFloat(Edit3.Text);
if TRownanieKwadratowe.Rozwiazanie(a,b,c,x1,x2)
  then ShowMessage('Rozwizania: x1='+FloatToStr(x1)+', x2='+FloatToStr(x2))
  else ShowMessage('Rwnanie nie ma rozwiza');
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Caption:=TRownanieKwadratowe.Opis;
end;

end.
